﻿using System;
using System.Windows.Forms;
using RDR2;
using RDR2.UI;
using RDR2.Native;
using RDR2.Math;

namespace HCL_Superpower_01
{
    public class Main : Script
    {
        Player player = Game.Player;
        Ped playerPed = Game.Player.Character;
        bool FLYON = false;
        bool WPressed = false;
        bool SpacePressed = false;
        float FlySpeed = 35.0f;

        public Main()
        {
            KeyDown += OnKeyDown;
            KeyUp += OnKeyUp;
            Tick += OnTick;
            Interval = 1;
        }

        private void OnTick(object sender, EventArgs e)
        {
            Ped playerPed = Game.Player.Character;   
            if (FLYON)
            {
                     if (player.Character.IsInVehicle())
                     {
                            Function.Call(Hash.SET_PED_GRAVITY, playerPed, true);
                            Function.Call(Hash.SET_PED_CAN_RAGDOLL, playerPed, true);
                            Function.Call(Hash.SET_PLAYER_CAN_USE_COVER, player, true);
                            FLYON = false;
                            WPressed = false;
                            SpacePressed = false;
	            RDR2.UI.Screen.ShowSubtitle("Fly Mode Off");
                     }
                     else
                     {
                            if (WPressed)
                            {
                                   Function.Call(Hash.APPLY_FORCE_TO_ENTITY, playerPed, 1, (0), (FlySpeed), (0), 0,0,0, 0, true, true, true, true, true);
                                   Function.Call(Hash.SET_ENTITY_ROTATION, playerPed, 0, 0, (NC_Get_Cam_Rotation()).Z, 2, true); 
                                   Function.Call(Hash.SET_ENTITY_VELOCITY, playerPed, 0, 0, 0);
                            }
                            if (SpacePressed)
                            {
                                   Function.Call(Hash.APPLY_FORCE_TO_ENTITY, playerPed, 1, (0), (0), (FlySpeed), 0,0,0, 0, true, true, true, true, true);
                                   Function.Call(Hash.SET_ENTITY_VELOCITY, playerPed, 0, 0, 0);
                            }
                            Function.Call(Hash.SET_PED_GRAVITY, playerPed, false);
                            if (Function.Call<bool>(Hash.IS_PED_RAGDOLL, playerPed))
                            {
                                  Vector3 currentPosition = playerPed.Position; 
                                  Function.Call(Hash.SET_ENTITY_COORDS, playerPed, currentPosition.X, currentPosition.Y, (currentPosition.Z - 1), true, false, false, false);
                            }
                            if (Function.Call<bool>(Hash.IS_PED_JUMPING, playerPed))
                            {
                                  Vector3 currentPosition = playerPed.Position; 
                                  Function.Call(Hash.SET_ENTITY_COORDS, playerPed, currentPosition.X, currentPosition.Y, (currentPosition.Z - 1), true, false, false, false);
                            }
                     }
            }
        } 

        private void OnKeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.W && FLYON)
            {
                      if (!WPressed)
                      {
                              WPressed = true;
                      }
            }
            if (e.KeyCode == Keys.Space && FLYON)
            {
                      if (!SpacePressed)
                      {
                              SpacePressed = true;
                      }
            }
            if (e.Alt && FLYON)
            {
                      Function.Call(Hash.APPLY_FORCE_TO_ENTITY, playerPed, 1, (0), (0), (-1.5*FlySpeed), 0,0,0, 0, true, true, true, true, true);
                      Function.Call(Hash.SET_ENTITY_VELOCITY, playerPed, 0, 0, 0);
            }
        }

        private void OnKeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Z && !e.Shift)
            {
                if (player.Character.IsInVehicle())
                {
	     RDR2.UI.Screen.ShowSubtitle("Cannot take off in vehicle.");
                }
                else
                {
                     if (FLYON)
                     {
                           Function.Call(Hash.SET_PED_GRAVITY, playerPed, true);
                           Function.Call(Hash.SET_PED_CAN_RAGDOLL, playerPed, true);
                           Function.Call(Hash.SET_PLAYER_CAN_USE_COVER, player, true);
                           Function.Call(Hash.SET_PLAYER_INVINCIBLE, player, false);    
                           FLYON = false;
                           WPressed = false;
                           SpacePressed = false;
	           RDR2.UI.Screen.ShowSubtitle("Fly Mode Off");
                     }
                     else
                     {
                           Function.Call(Hash.SET_PED_CAN_RAGDOLL, playerPed, false);
                           Function.Call(Hash.SET_PLAYER_CAN_USE_COVER, player, false);
                           Function.Call(Hash.SET_PLAYER_INVINCIBLE, player, true);    
                           FLYON = true;
	           RDR2.UI.Screen.ShowSubtitle("Fly Mode On");
                           if (Function.Call<bool>(Hash.IS_PLAYER_CLIMBING, player))
                           {
                                  Vector3 currentPosition = playerPed.Position; 
                                  Function.Call(Hash.SET_ENTITY_COORDS, playerPed, currentPosition.X, currentPosition.Y, (currentPosition.Z - 1), true, false, false, false);
                           }
                           if (Function.Call<bool>(Hash.IS_PED_FALLING, playerPed))
                           {
                                  Vector3 currentPosition = playerPed.Position; 
                                  Function.Call(Hash.SET_ENTITY_COORDS, playerPed, currentPosition.X, currentPosition.Y, (currentPosition.Z - 1), true, false, false, false);
                           }
                     }
                }
            }
            if (e.KeyCode == Keys.W && FLYON)
            {
                      WPressed = false;
            }
            if (e.KeyCode == Keys.Space && FLYON)
            {
                      SpacePressed = false;
            }
        }

        public Vector3 NC_Get_Cam_Rotation()
        {
            try
            {
                return Function.Call<Vector3>(Hash.GET_GAMEPLAY_CAM_ROT, 0);
            }
            catch
            {

            }
            return new Vector3(0, 0, 0);
        } 
    }
}
